<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

class Configuracion extends BaseController
{
	public function __construct(){
 		$this->tipologia            = new \App\Models\TipologiaModel();
 		$this->banco                = new \App\Models\BancosModel();
 		$this->formasPago           = new \App\Models\FormaPagoModel();
 		$this->modalidadPago        = new \App\Models\ModalidadPagoModel();
 		$this->detraccionCodigo     = new \App\Models\DetraccionCodigoModel();
 		$this->cuentaContable       = new \App\Models\CuentaContableModel();
 		$this->cuentaContableCategorias = new \App\Models\CuentaContableCategoriaModel();
 		$this->cuentaContableSubcategorias = new \App\Models\CuentaContableSubcategoriaModel();
 		
 		$this->regionPais           = new \App\Models\RegionPaisModel();
        $this->regionDepartamento   = new \App\Models\RegionDepartamentoModel();
        $this->regionProvincia      = new \App\Models\RegionProvinciaModel();
        $this->regionDistrito       = new \App\Models\RegionDistritoModel();
        
 		$this->proveedor            = new \App\Models\ProveedorModel();
 		$this->proveedorTipologia   = new \App\Models\ProveedorTipologiaModel();
 		$this->proveedorPago        = new \App\Models\ProveedorPagoModel();
 		
 		//Funciones de sistema externo proveedores
 		$this->proveedorExternos    = new \App\Models\ExternosProveedorModel();
 		
 		$this->externosAcceso       = new \App\Models\ExternosAccesoModel();
	}

    /************************* CÓDIGOS DE DETRACCIÓN **************************/
    
    public function listadoCodigosDetraccion()
    {
        if(isset($this->items['id']))
        {
            $where = array(
                "Estado"    => "A"
            );
            
            $listado = $this->detraccionCodigo->where($where)->findAll();
                
            $elementos=array();
    
    		if (!empty($listado)) {
                foreach ($listado as $items) {
                    $elementos[] = array(
    					'id' => (string) $items['CodigoDetraccionSUNAT'],
                        'text' => (string) $items['CodigoDetraccionSUNAT'].' | '.$items['Definicion']
                    );
                }
    
                $resultado = array(
    				'listadoCodigosDetraccion' => json_encode($elementos)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
        } 
        else 
        {
    		$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);	
    }

	/**************************************************************************/
	
    /******************************* TIPOLOGIA ********************************/
    
	public function listarTipologias()
	{
    	if (isset($this->items['id'])) 
    	{
    	    $listadoTipologia = $this->tipologia->findAll();
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Tipologías | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Tipologías',
				'listadoTipologia'      => $listadoTipologia
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_tipologias',$data);		
        } else {
            return view('errors/500');
        }
	}
	
	public function registrarTipologia()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $descripcion    = ucwords(mb_strtolower($this->request->getPost('txtDescripcionTipologia_i')));
        $observacion    = $this->request->getPost('txtObservacionTipologia_i');
        
        // $descripcion    = ucwords(mb_strtolower(htmlspecialchars($this->request->getPost('txtDescripcionTipologia_i'), ENT_QUOTES,'UTF-8')));
        // $observacion    = htmlspecialchars($this->request->getPost('txtObservacionTipologia_i'), ENT_QUOTES,'UTF-8');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($descripcion, 'required|trim|alphaspecial|minlength[1]|maxlength[50]', 'Descripción');
        

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereExistencia = array(
            "Descripcion" => $descripcion
        );
        
		$tipologiaExistente = $this->tipologia->where($whereExistencia)->findAll();
        // var_dump($tipologiaExistente); exit;
        if(count($tipologiaExistente)>0)
        {
            $msgExistencia .= "<li>La tipología ya fue registrada previamente. [CAMPO] <small>DESCRIPCIÓN</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'Descripcion'   => $descripcion,
            'Observacion'   => $observacion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Creación de tipología.",    
            'Estado'        => 'A'
        );

        $lastId = $this->tipologia->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $descripcion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosTipologia()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idTipologia = $this->request->getPost('idTipologia');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idTipologia, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosTipologia = $this->tipologia->where('IdTipologia', $idTipologia)->first();

		if(!empty($datosTipologia)){
			$resultado = array(
				'idtipologia'   => (string) $idTipologia,
				'descripcion'   => (string) $datosTipologia['Descripcion'],
				'observacion'   => (string) $datosTipologia['Observacion']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarTipologia($idTipologia)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $descripcion    = ucwords(mb_strtolower($this->request->getPost('txtDescripcionTipologia_i')));
        $observacion    = $this->request->getPost('txtObservacionTipologia_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($descripcion, 'required|trim|alphaspecial|minlength[1]|maxlength[50]', 'Descripción');
        

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'Descripcion'       => $descripcion,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->tipologia->update([$idTipologia], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $descripcion);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoTipologia()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idTipologia    = $this->request->getPost('idTipologia');
        $estado         = $this->request->getPost('estado');
        $motivo         = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idTipologia, 'required|trim|numeric', 'ID Tipología');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->tipologia->update([$idTipologia], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idTipologia);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listadoTipologias()
    {
        if(isset($this->items['id']))
        {
            $where = array(
                "Estado"    => "A"
            );
            
            $listado = $this->tipologia->where($where)->findAll();
                
            $elementos=array();
    
    		if (!empty($listado)) {
                foreach ($listado as $items) {
                    $elementos[] = array(
    					'id' => (string) $items['IdTipologia'],
                        'text' => (string) $items['Descripcion']
                    );
                }
    
                $resultado = array(
    				'listadoTipologias' => json_encode($elementos)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
        } 
        else 
        {
    		$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);	
    }

	/**************************************************************************/
	
    /**************************** BANCOS **************************************/
    
	public function listarBancos()
	{
    	if (isset($this->items['id'])) 
    	{
    	    $listadoBancos = $this->banco->findAll();
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Bancos | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Listado de Bancos',
				'listadoBancos'         => $listadoBancos
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_bancos',$data);		
        } else {
            return view('errors/500');
        }
	}
	
	public function registrarBanco()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $interno    = $this->request->getPost('txtCodigoInternoBanco_i');
        $banco      = ucwords(mb_strtolower($this->request->getPost('txtNombreBanco_i')));
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($interno, 'required|trim|alphaspecial|minlength[1]|maxlength[30]', 'Código interno');
        $error .= $this->complementos->validaCampo($banco, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Nombre');
        

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$ciExistente = $this->banco->where("CodigoInterno",$interno)->findAll();
		$nombreExistente = $this->banco->where("Nombre",$banco)->findAll();
        
        if(count($ciExistente)>0)
        {
            $msgExistencia .= "<li>El banco ya fue registrada previamente. [CAMPO] <small>CÓDIGO INTERNO</small></li>";
        }

        if(count($nombreExistente)>0)
        {
            $msgExistencia .= "<li>El banco ya fue registrada previamente. [CAMPO] <small>NOMBRE BANCO</small></li>";
        }
        
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'CodigoInterno' => $interno,
            'Nombre'        => $banco,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Creación de banco.",    
            'Estado'        => 'A'
        );

        $lastId = $this->banco->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $banco);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosBanco()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idBanco = $this->request->getPost('idBanco');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idBanco, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosBanco = $this->banco->where('IDBanco', $idBanco)->first();

		if(!empty($datosBanco)){
			$resultado = array(
				'idbanco'       => (string) $idBanco,
				'codigointerno' => (string) $datosBanco['CodigoInterno'],
				'banco'         => (string) $datosBanco['Nombre']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarBanco($idBanco)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $interno    = $this->request->getPost('txtCodigoInternoBanco_i');
        $banco      = ucwords(mb_strtolower($this->request->getPost('txtNombreBanco_i')));
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($interno, 'required|trim|alphaspecial|minlength[1]|maxlength[30]', 'Código interno');
        $error .= $this->complementos->validaCampo($banco, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Nombre');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'CodigoInterno'     => $interno,
            'Nombre'            => $banco,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->banco->update([$idBanco], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $banco);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoBanco()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idBanco        = $this->request->getPost('idBanco');
        $estado         = $this->request->getPost('estado');
        $motivo         = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idBanco, 'required|trim|numeric', 'ID Banco');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->banco->update([$idBanco], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idBanco);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listadoBanco()
    {
        if(isset($this->items['id']))
        {
            $where = array(
                "Estado"    => "A"
            );
            
            $listado = $this->banco->where($where)->findAll();
                
            $elementos=array();
    
    		if (!empty($listado)) {
                foreach ($listado as $items) {
                    $elementos[] = array(
    					'id' => (string) $items['CodigoInterno'],
                        'text' => (string) $items['Nombre']
                    );
                }
    
                $resultado = array(
    				'listadoBancos' => json_encode($elementos)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
        } 
        else 
        {
    		$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);	
    }

	/**************************************************************************/
	
    /************************ FORMAS DE PAGO **********************************/
    
	public function listarFormasPago()
	{
    	if (isset($this->items['id'])) 
    	{
    	    $listadoFormasPago = $this->formasPago->findAll();
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Formas de Pago | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Listado de formas de pago',
				'listadoFormasPago'     => $listadoFormasPago
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_formas_pago',$data);		
        } else {
            return view('errors/500');
        }
	}
	
	public function registrarFormaPago()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $codigo     = $this->request->getPost('txtCodigoFormaPago_i');
        $formapago  = ucwords(mb_strtolower($this->request->getPost('txtFormaPago_i')));
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($codigo, 'required|trim|alphaspecial|minlength[1]|maxlength[30]', 'Código');
        $error .= $this->complementos->validaCampo($formapago, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Forma de Pago');
        

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$codigoExistente = $this->formasPago->where("Codigo",$codigo)->findAll();
		$fpExistente = $this->formasPago->where("FormaPago",$formapago)->findAll();
        
        if(count($codigoExistente)>0)
        {
            $msgExistencia .= "<li>La forma de pago ya fue registrada previamente. [CAMPO] <small>CÓDIGO</small></li>";
        }

        if(count($fpExistente)>0)
        {
            $msgExistencia .= "<li>La forma de pago ya fue registrada previamente. [CAMPO] <small>FORMA DE PAGO</small></li>";
        }
        
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'Codigo'        => $codigo,
            'FormaPago'     => $formapago,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Creación de forma de pago.",    
            'Estado'        => 'A'
        );

        $lastId = $this->formasPago->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $formapago);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosFormaPago()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idFormaPago = $this->request->getPost('idFormaPago');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idFormaPago, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosFormaPago = $this->formasPago->where('IDFormaPago', $idFormaPago)->first();

		if(!empty($datosFormaPago)){
			$resultado = array(
				'idformapago'   => (string) $idFormaPago,
				'codigo'        => (string) $datosFormaPago['Codigo'],
				'formapago'     => (string) $datosFormaPago['FormaPago']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarFormaPago($idFormaPago)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $codigo     = $this->request->getPost('txtCodigoFormaPago_i');
        $formapago  = ucwords(mb_strtolower($this->request->getPost('txtFormaPago_i')));
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($codigo, 'required|trim|alphaspecial|minlength[1]|maxlength[30]', 'Código');
        $error .= $this->complementos->validaCampo($formapago, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Forma de Pago');
        

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'Codigo'            => $codigo,
            'FormaPago'         => $formapago,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->formasPago->update([$idFormaPago], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $formapago);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoFormaPago()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idFormaPago    = $this->request->getPost('idFormaPago');
        $estado         = $this->request->getPost('estado');
        $motivo         = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idFormaPago, 'required|trim|numeric', 'ID Forma Pago');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->formasPago->update([$idFormaPago], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idFormaPago);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listadoFormasPago()
    {
        if(isset($this->items['id']))
        {
            $where = array(
                "Estado"    => "A"
            );
            
            $listado = $this->formasPago->where($where)->findAll();
                
            $elementos=array();
    
    		if (!empty($listado)) {
                foreach ($listado as $items) {
                    $elementos[] = array(
    					'id' => (string) $items['Codigo'],
                        'text' => (string) $items['FormaPago']
                    );
                }
    
                $resultado = array(
    				'listadoFormasPago' => json_encode($elementos)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
        } 
        else 
        {
    		$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);	
    }

	/**************************************************************************/
	
    /*********************** MODALIDAD DE PAGO ********************************/
    
	public function listarModalidadPago()
	{
    	if (isset($this->items['id'])) 
    	{
    	    $listadoModalidadPago = $this->modalidadPago->findAll();
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Modalidad de Pago | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Listado de modalidades de pago',
				'listadoModalidadPago'  => $listadoModalidadPago
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_modalidad_pago',$data);		
        } else {
            return view('errors/500');
        }
	}
	
	public function registrarModalidadPago()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $codigo     = $this->request->getPost('txtCodigoModalidadPago_i');
        $modalidadpago  = ucwords(mb_strtolower($this->request->getPost('txtModalidadPago_i')));
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($codigo, 'required|trim|alphaspecial|minlength[1]|maxlength[30]', 'Código');
        $error .= $this->complementos->validaCampo($modalidadpago, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Modalidad de Pago');
        

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$codigoExistente = $this->modalidadPago->where("Codigo",$codigo)->findAll();
		$mpExistente = $this->modalidadPago->where("ModalidadPago",$modalidadpago)->findAll();
        
        if(count($codigoExistente)>0)
        {
            $msgExistencia .= "<li>La modalidad de pago ya fue registrada previamente. [CAMPO] <small>CÓDIGO</small></li>";
        }

        if(count($mpExistente)>0)
        {
            $msgExistencia .= "<li>La modalidad de pago ya fue registrada previamente. [CAMPO] <small>MODALIDAD DE PAGO</small></li>";
        }
        
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'Codigo'        => $codigo,
            'ModalidadPago' => $modalidadpago,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Creación de modalidad de pago.",    
            'Estado'        => 'A'
        );

        $lastId = $this->modalidadPago->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $modalidadpago);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosModalidadPago()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idModalidadPago = $this->request->getPost('idModalidadPago');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idModalidadPago, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosModalidadPago = $this->modalidadPago->where('IDModalidadPago', $idModalidadPago)->first();

		if(!empty($datosModalidadPago)){
			$resultado = array(
				'idmodalidadpago'   => (string) $idModalidadPago,
				'codigo'            => (string) $datosModalidadPago['Codigo'],
				'modalidadpago'     => (string) $datosModalidadPago['ModalidadPago']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarModalidadPago($idModalidadPago)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $codigo     = $this->request->getPost('txtCodigoModalidadPago_i');
        $modalidadpago  = ucwords(mb_strtolower($this->request->getPost('txtModalidadPago_i')));
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($codigo, 'required|trim|alphaspecial|minlength[1]|maxlength[30]', 'Código');
        $error .= $this->complementos->validaCampo($modalidadpago, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Modalidad de Pago');
        

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'Codigo'            => $codigo,
            'ModalidadPago'     => $modalidadpago,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->modalidadPago->update([$idModalidadPago], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $modalidadpago);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoModalidadPago()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idModalidadPago= $this->request->getPost('idModalidadPago');
        $estado         = $this->request->getPost('estado');
        $motivo         = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idModalidadPago, 'required|trim|numeric', 'ID Modalidad Pago');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->modalidadPago->update([$idModalidadPago], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idModalidadPago);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listadoModalidadPago()
    {
        if(isset($this->items['id']))
        {
            $where = array(
                "Estado"    => "A"
            );
            
            $listado = $this->modalidadPago->where($where)->findAll();
                
            $elementos=array();
    
    		if (!empty($listado)) {
                foreach ($listado as $items) {
                    $elementos[] = array(
    					'id' => (string) $items['Codigo'],
                        'text' => (string) $items['ModalidadPago']
                    );
                }
    
                $resultado = array(
    				'listadoModalidadPago' => json_encode($elementos)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
        } 
        else 
        {
    		$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);	
    }

	/**************************************************************************/
	
    /*********************** CUENTAS CONTABLES ********************************/
    
	public function listarCuentasContables()
	{
    	if (isset($this->items['id'])) 
    	{
    	    $listadoCuentaContable = $this->cuentaContable->findAll();
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Cuentas Contables | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Listado de cuentas contables',
				'listadoCuentaContable' => $listadoCuentaContable
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_cuentas_contables',$data);		
        } else {
            return view('errors/500');
        }
	}
	
	public function registrarCuentaContable()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $codigo         = $this->request->getPost('txtCodigoCuentaContable_i');
        $cuentacontable = ucwords(mb_strtolower($this->request->getPost('txtNombreCuentaContable_i')));
        $descripcion    = $this->request->getPost('txtDescripcionCuentaContable_i');
        $observacion    = $this->request->getPost('txtObservacionCuentaContable_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($codigo, 'required|trim|numeric|minlength[1]|maxlength[10]', 'Código Cuenta Contable');
        $error .= $this->complementos->validaCampo($cuentacontable, 'required|trim|alphaspecial|minlength[1]|maxlength[200]', 'Cuenta Contable');
        $error .= $this->complementos->validaCampo($descripcion, 'trim|alphaspecial|minlength[1]|maxlength[50]', 'Descripción');
        $error .= $this->complementos->validaCampo($observacion, 'trim|alphaspecial', 'Observación');
        

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$codigoExistente = $this->cuentaContable->where("CodigoCuentaContable",$codigo)->findAll();
		$ccExistente = $this->cuentaContable->where("CuentaContable",$cuentacontable)->findAll();
        
        if(count($codigoExistente)>0)
        {
            $msgExistencia .= "<li>El código ya fue registrada previamente. [CAMPO] <small>CÓDIGO</small></li>";
        }

        if(count($ccExistente)>0)
        {
            $msgExistencia .= "<li>La cuenta contable ya fue registrada previamente. [CAMPO] <small>CUENTA CONTABLE</small></li>";
        }
        
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'CodigoCuentaContable'  => $codigo,
            'CuentaContable'        => $cuentacontable,
            'Descripcion'           => $descripcion,
            'Observacion'           => $observacion,
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress(),
            'UsuarioEstado'         => $this->items['id'],
            'FechaEstado'           => $fechaActual,    
            'MotivoEstado'          => "Creación de cuenta contable.",    
            'Estado'                => 'A'
        );

        $lastId = $this->cuentaContable->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $cuentacontable);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosCuentaContable()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idCuentaContable = $this->request->getPost('idCuentaContable');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idCuentaContable, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosCuentaContable = $this->cuentaContable->where('IDCuentaContable', $idCuentaContable)->first();

		if(!empty($datosCuentaContable)){
			$resultado = array(
				'idcuentacontable'  => (string) $idCuentaContable,
				'codigo'            => (string) $datosCuentaContable['CodigoCuentaContable'],
				'cuentacontable'    => (string) $datosCuentaContable['CuentaContable'],
				'descripcion'       => (string) $datosCuentaContable['Descripcion'],
				'observacion'       => (string) $datosCuentaContable['Observacion']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarCuentaContable($idCuentaContable)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $codigo         = $this->request->getPost('txtCodigoCuentaContable_i');
        $cuentacontable = ucwords(mb_strtolower($this->request->getPost('txtNombreCuentaContable_i')));
        $descripcion    = $this->request->getPost('txtDescripcionCuentaContable_i');
        $observacion    = $this->request->getPost('txtObservacionCuentaContable_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($codigo, 'required|trim|numeric|minlength[1]|maxlength[10]', 'Código Cuenta Contable');
        $error .= $this->complementos->validaCampo($cuentacontable, 'required|trim|alphaspecial|minlength[1]|maxlength[200]', 'Cuenta Contable');
        $error .= $this->complementos->validaCampo($descripcion, 'trim|alphaspecial|minlength[1]|maxlength[50]', 'Descripción');
        $error .= $this->complementos->validaCampo($observacion, 'trim|alphaspecial', 'Observación');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'CodigoCuentaContable'  => $codigo,
            'CuentaContable'        => $cuentacontable,
            'Descripcion'           => $descripcion,
            'Observacion'           => $observacion,
            'UsuarioModifica'       => $this->items['id'],
            'FechaModifica'         => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress()
        );

        $lastId = $this->cuentaContable->update([$idCuentaContable], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $cuentacontable);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoCuentaContable()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idCuentaContable= $this->request->getPost('idCuentaContable');
        $estado         = $this->request->getPost('estado');
        $motivo         = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idCuentaContable, 'required|trim|numeric', 'ID Cuenta Contable');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->cuentaContable->update([$idCuentaContable], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idCuentaContable);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listadoCuentasContables()
    {
        if(isset($this->items['id']))
        {
            $where = array(
                "Estado"    => "A"
            );
            
            $listado = $this->cuentaContable->where($where)->findAll();
                
            $elementos=array();
    
    		if (!empty($listado)) {
                foreach ($listado as $items) {
                    $elementos[] = array(
    					'id' => (string) $items['IDCuentaContable'],
                        'text' => (string) $items['CodigoCuentaContable'].' | '.$items['CuentaContable']
                    );
                }
    
                $resultado = array(
    				'listadoCuentasContables' => json_encode($elementos)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
        } 
        else 
        {
    		$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);	
    }

	/**************************************************************************/
	
    /********************* CUENTAS CONTABLES - CATEGORÍAS *********************/
    
    public function listarCategoriasCuentaContable($idCuentaContable)
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
            $cuentaContable = $this->cuentaContable->where('IDCuentaContable', $idCuentaContable)->first();
			$listaCategorias = $this->cuentaContableCategorias->listadoCategoriasCuentaContable($idCuentaContable);
			
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Categorías - Cuenta Contable | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Categorías - '.$cuentaContable['CuentaContable'],
                'previo'                => 'listar-cuentas-contables',
                'cuentaContable'        => $cuentaContable,
				'listaCategorias'       => $listaCategorias
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_cuenta_contable_categorias',$data);			
		} else {
			return view('errors/500');
		}
    }
    
    public function registrarCategoriaCuentaContable()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError           = TRUE;
        $idCuentaContable   = $this->request->getPost('txtIDCuentaContable_i');
        $categoria          = ucwords(mb_strtolower($this->request->getPost('txtCategoriaCC_i')));
        $observacion        = $this->request->getPost('txtObservacionCategoriaCC_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idCuentaContable, 'required|trim|numeric', 'ID Cuenta Contable');
        $error .= $this->complementos->validaCampo($categoria, 'required|trim|minlength[1]|maxlength[200]', 'Categoría');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereCategoria = array(
            'IDCuentaContable'  => $idCuentaContable,
            'Categoria'         => $categoria
        );
        
		$categoriaExistente = $this->cuentaContableCategorias->where($whereCategoria)->findAll();
        
        if(count($categoriaExistente)>0)
        {
            $msgExistencia .= "<li>La categoría ya existe en la cuenta contable. [CAMPO] <small>CATEGORÍA</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDCuentaContable'  => $idCuentaContable,
            'Categoria'         => $categoria,
            'Observacion'       => $observacion,
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => 'A',
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => 'Categoría creada.'
        );

        $lastId = $this->cuentaContableCategorias->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $categoria);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function obtenerDatosCategoriaCuentaContable() 
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idCategoria = $this->request->getPost('idCategoriaCC');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idCategoria, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosCategoria = $this->cuentaContableCategorias->where('IDCategoriaCC', $idCategoria)->first();

		if(!empty($datosCategoria)){
			$resultado = array(
				'idcategoriacc' => (string) $idCategoria,
				'categoria'     => (string) $datosCategoria['Categoria'],
				'observacion'   => (string) $datosCategoria['Observacion']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
    public function modificarCategoriaCuentaContable($idCategoriaCC)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError           = TRUE;
        $categoria          = ucwords(mb_strtolower($this->request->getPost('txtCategoriaCC_i')));
        $observacion        = $this->request->getPost('txtObservacionCategoriaCC_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($categoria, 'required|trim|minlength[1]|maxlength[200]', 'Categoría');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $data = array (
            'Categoria'         => $categoria,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->cuentaContableCategorias->update([$idCategoriaCC], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idCategoriaCC);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarEstadoCategoriaCuentaContable()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idCategoria    = $this->request->getPost('idCategoriaCC');
        $estado         = $this->request->getPost('estado');
        $motivo         = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idCategoria, 'required|trim|numeric', 'ID Categoría');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => $estado,
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => $motivo
        );
        
        $lastId = $this->cuentaContableCategorias->update([$idCategoria], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idCategoria);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function listadoCategoriaCuentaContable()
	{
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idCuentaContable = $this->request->getPost('idCuentaContable');

        if($idCuentaContable == 'TOTAL')
        {
            $whereCategorias = array('Estado' => "A");
        }
        else
        {
            $whereCategorias = array('IDCuentaContable' => $idCuentaContable, 'Estado' => "A");
        }
        
        $listadoCategorias = $this->cuentaContableCategorias->listadoCategorias($whereCategorias);
        
        $categorias=array();

		if (!empty($listadoCategorias)) {
            foreach ($listadoCategorias as $items) {
                if($idCuentaContable == 'TOTAL')
                {
                    $categorias[] = array(
    					'id' => (string) $items['IDCategoriaCC'],
             	      //  'text' => (string) $items['CodigoCuentaContable'].' - '.$items['CuentaContable'].' | '.$items['Categoria'],
             	        'text' => (string) $items['Categoria']
                    );
                }
                else
                {
                    $categorias[] = array(
    					'id' => (string) $items['IDCategoriaCC'],
             	        'text' => (string) $items['Categoria'],
                    );
                }
                
            }

            $resultado = array(
				'listadoCategorias' => json_encode($categorias)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado);		
	}
	
	/**************************************************************************/
	
    /******************* CUENTAS CONTABLES - SUBCATEGORÍAS ********************/
    
    public function listarSubcategoriasCuentaContable($idCategoriaCC)
    {
        if(isset($this->items['id'])){

			/* ACCIONES */
            $categoria = $this->cuentaContableCategorias->obtenerCategoria($idCategoriaCC);
			$listaSubcategorias = $this->cuentaContableSubcategorias->listadoSubcategoriasCategoriaCC($idCategoriaCC);
			
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Subcategorías - Cuenta Contable | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Subcategorías - '.$categoria['Categoria'].' - '.$categoria['CuentaContable'],
                'previo'                => 'listar-categorias-cuenta-contable/'.$categoria['IDCategoriaCC'],
                'categoria'             => $categoria,
				'listaSubcategorias'    => $listaSubcategorias
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_cuenta_contable_subcategorias',$data);			
		} else {
			return view('errors/500');
		}
    }
    
    public function registrarSubcategoriaCuentaContable()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError           = TRUE;
        $idCategoriaCC      = $this->request->getPost('txtIDCategoriaCC_i');
        $subcategoria       = ucwords(mb_strtolower($this->request->getPost('txtSubcategoriaCC_i')));
        $observacion        = $this->request->getPost('txtObservacionSubcategoriaCC_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idCategoriaCC, 'required|trim|numeric', 'ID Categoría Cuenta Contable');
        $error .= $this->complementos->validaCampo($subcategoria, 'required|trim|minlength[1]|maxlength[200]', 'Subcategoría');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereSubcategoria = array(
            'IDCategoriaCC' => $idCategoriaCC,
            'Subcategoria'  => $subcategoria
        );
        
		$subcategoriaExistente = $this->cuentaContableSubcategorias->where($whereSubcategoria)->findAll();
        
        if(count($subcategoriaExistente)>0)
        {
            $msgExistencia .= "<li>La subcategoría ya existe en la categoría. [CAMPO] <small>SUBCATEGORÍA</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDCategoriaCC' => $idCategoriaCC,
            'Subcategoria'  => $subcategoria,
            'Observacion'   => $observacion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'Estado'        => 'A',
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => 'Subcategoría creada.'
        );

        $lastId = $this->cuentaContableSubcategorias->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $subcategoria);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }

	public function obtenerDatosSubcategoriaCuentaContable() 
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idSubcategoria = $this->request->getPost('idSubcategoriaCC');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idSubcategoria, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosSubcategoria = $this->cuentaContableSubcategorias->where('IDSubcategoriaCC', $idSubcategoria)->first();

		if(!empty($datosSubcategoria)){
			$resultado = array(
				'idsubcategoriacc'  => (string) $idSubcategoria,
				'subcategoria'      => (string) $datosSubcategoria['Subcategoria'],
				'observacion'       => (string) $datosSubcategoria['Observacion']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
    public function modificarSubcategoriaCuentaContable($idSubcategoriaCC)
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $subcategoria       = ucwords(mb_strtolower($this->request->getPost('txtSubcategoriaCC_i')));
        $observacion        = $this->request->getPost('txtObservacionSubcategoriaCC_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($subcategoria, 'required|trim|minlength[1]|maxlength[200]', 'Subcategoría');
        $error .= $this->complementos->validaCampo($observacion, 'trim', 'Observación');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $data = array (
            'Subcategoria'      => $subcategoria,
            'Observacion'       => $observacion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->cuentaContableSubcategorias->update([$idSubcategoriaCC], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idSubcategoriaCC);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function modificarEstadoSubcategoriaCuentaContable()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idSubcategoriaCC   = $this->request->getPost('idSubcategoriaCC');
        $estado             = $this->request->getPost('estado');
        $motivo             = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idSubcategoriaCC, 'required|trim|numeric', 'ID Subcategoría');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'Estado'            => $estado,
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => $motivo
        );
        
        $lastId = $this->cuentaContableSubcategorias->update([$idSubcategoriaCC], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idSubcategoriaCC);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function listadoSubcategoriaCuentaContable()
	{
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
		$idCategoria = $this->request->getPost('idCategoria');

        if($idCategoria == 'TOTAL')
        {
            $whereSubcategorias = array('Estado' => "A");
        }
        else
        {
            $whereSubcategorias = array('IDCategoriaCC' => $idCategoria, 'Estado' => "A");
        }
        
        $listadoSubcategorias = $this->cuentaContableSubcategorias->listadoSubcategorias($whereSubcategorias);
        
        $subcategorias=array();

		if (!empty($listadoSubcategorias)) {
            foreach ($listadoSubcategorias as $items) {
                if($idCategoria == 'TOTAL')
                {
                    $subcategorias[] = array(
    					'id' => (string) $items['IDSubcategoriaCC'],
             	        'text' => (string) $items['CodigoCuentaContable'].' - '.$items['CuentaContable'].' | '.$items['Categoria'].' - '.$items['Subcategoria'],
                    );
                }
                else
                {
                    $subcategorias[] = array(
    					'id' => (string) $items['IDSubcategoriaCC'],
             	        'text' => (string) $items['Subcategoria'],
                    );
                }
                
            }

            $resultado = array(
				'listadoSubcategorias' => json_encode($subcategorias)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado);		
	}
	
	public function exportarSubcategoriasCuentaContable()
	{
	    $whereSubcategorias = array('Estado' => "A");
	    $listadoSubcategoria = $this->cuentaContableSubcategorias->listadoSubcategorias($whereSubcategorias);
	    
        $filename = "subcategoria_cuenta_contable.xlsx";
        $writer = WriterEntityFactory::createXLSXWriter();
        //$writer->setFieldDelimiter(';');
        $writer->setShouldUseInlineStrings(true); // default (and recommended) value
        $writer->openToBrowser($filename);
        
        $cells = [
            WriterEntityFactory::createCell("Cuenta Contable"),
            WriterEntityFactory::createCell("Categoría"),
            WriterEntityFactory::createCell("Subcategoría")
        ];
        
        /** add a row at a time */
        $singleRow = WriterEntityFactory::createRow($cells);
        $writer->addRow($singleRow);
        
        foreach($listadoSubcategoria as $key=>$item)
        {
			$cells = [
                WriterEntityFactory::createCell($item['CuentaContable']),
                WriterEntityFactory::createCell($item['Categoria']),
                WriterEntityFactory::createCell($item['Subcategoria'])
            ];
            
            /** add a row at a time */
            $singleRow = WriterEntityFactory::createRow($cells);
            $writer->addRow($singleRow);

        }
        
        $writer->close();
	}
	
	/**************************************************************************/
	
    /************************** PROVEEDORES ***********************************/
    
	public function listarProveedores()
	{
    	if (isset($this->items['id'])) 
    	{
            $data = array (
				'session'               => 'on',
				'titulo'                => 'Proveedores | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Listado de Proveedores'
			);
			
            $data = array_merge($data, $this->items);

            return view('configuracion/listar_proveedores', $data);
        } else {
            return view('errors/500');
        }
	}
	
    // public function proveedoresServerside()
    // {
    //     $orderBy = " ORDER BY ";

    //     foreach ($this->request->getGet('order') as $order) {
    //         $orderBy .= $order['column'] + 1 . " {$order['dir']}, ";
    //     }

    //     $orderBy = substr($orderBy, 0, -2);
    //     $columns = $this->request->getGet('columns');
    //     $fields = ['proveedor.RUC','proveedor.Nombre','proveedor.Contacto','Departamento','Provincia','Distrito','proveedor.Telefono01', 'proveedor.Telefono02','proveedor.Email', 'proveedor.Estado','acciones_proveedor'];
    //     $where = '';

    //     foreach ($columns as $k => $column) {
    //         if ($this->request->getGet('search')['value']!="") {
    //             if($k == 10){}
    //             else
    //             {
    //                 $where .= $fields[$k]." LIKE '%".$this->request->getGet('search')['value']."%' OR ";
    //             }
                
    //         }
    //     }

    //     $where = substr($where, 0, -5);
    //     $length = $this->request->getGet('length');
    //     $start = $this->request->getGet('start'); 

    //     /* LISTAR ORDEN DE COMPRA */
    //     $listaProveedor = $this->proveedor->listaGeneralProveedor($orderBy,$where,$length,$start);
    //     echo json_encode($listaProveedor);
    // }
    
    public function proveedoresServerside()
    {
        $adicionales = array(
            "IDPerfil"  => $this->items['idPerfil'],
            "IDUsuario" => $this->items['id']
        );
        /* LISTAR PROVEEDOR */
        $dataServerside = $this->proveedor->listaGeneralProveedor($this->request->getGet(), $adicionales);
        $recordsTotal = !empty($dataServerside) ? count($dataServerside) : 0;
        $recordsFiltered = $this->proveedor->countAll();
        
        foreach($dataServerside as $key=>$value)
        {
            if(isset($value['IDDistrito']) && $value['IDDistrito'] != NULL && $value['IDDistrito'] != '')
            {
                $region = $this->regionDistrito->obtenerRegionxIDDistrito($value['IDDistrito']);
                $dataServerside[$key]['Departamento'] = $region['Departamento'];
                $dataServerside[$key]['Provincia'] = $region['Provincia'];
                $dataServerside[$key]['Distrito'] = $region['Distrito'];
            }
            else
            {
                $dataServerside[$key]['Departamento'] = "";
                $dataServerside[$key]['Provincia'] = "";
                $dataServerside[$key]['Distrito'] = "";
            }
            
            $acciones = "";
            $acciones .= "<div class='dropdown d-inline-block'>
    				<button class='btn btn-soft-secondary btn-sm dropdown' type='button' data-bs-toggle='dropdown' aria-expanded='false'>
    				<i class='ri-more-fill align-middle'></i>
    				</button>
    				<ul class='dropdown-menu dropdown-menu-end'>
    				    <li>
    						<a href='#!' class='dropdown-item d-flex justify-content-start align-items-center btnInformacionProveedor' data-bs-target='#editarProveedor' data-id='".$value['IDProveedor']."' data-accion='ver' id='ver-proveedor'>
    							<i class='ri-eye-fill align-bottom me-2 text-muted' style='font-size: 18px;'></i> Ver
    						</a>
    					</li>";
    					
    					if (in_array("UPDPRO", $this->items['permisos'])) 
    					{
        					$acciones .= "<li>
        						<a href='#!' class='dropdown-item edit-item-btn d-flex justify-content-start align-items-center btnInformacionProveedor' data-bs-target='#editarProveedor' data-id='".$value['IDProveedor']."' data-accion='editar' id='editar-proveedor'>
        							<i class='ri-pencil-fill align-bottom me-2 text-muted' style='font-size: 18px;'></i> Editar
        						</a>
        					</li>";
    					}
    					
    					if (in_array("UPPRMP", $this->items['permisos']))
    					{
        					$acciones .= "<li>
        						<a class='dropdown-item edit-item-btn d-flex justify-content-start align-items-center modalidadPagoProveedor' style='cursor: pointer;' data-bs-target='#editarModalidadPagoProveedor' data-id='".$value['IDProveedor']."'>
        							<i class='mdi mdi-cash-multiple align-bottom me-2 text-muted' style='font-size: 18px;'></i> Modalidades de Pago
        						</a>
        					</li>";
    					}
    					
    					if (in_array("UACPRO", $this->items['permisos']))
    					{
        					$acciones .= "<li>
        						<a href='".base_url()."/listar-accesos-proveedor/".$value['IDProveedor']."' class='dropdown-item d-flex justify-content-start align-items-center'>
        							<i class='mdi mdi-table-account align-bottom me-2 text-muted' style='font-size: 18px;'></i> Usuarios de Acceso
        						</a>
        					</li>";
    					}
    				// 	if (in_array("OCASPR", $this->items['permisos']))
    				// 	{
        // 					$acciones .= "<li>
        // 						<a href='".base_url()."/listar-ordenes-compra/".$value['IDProveedor']."' class='dropdown-item d-flex justify-content-start align-items-center'>
        // 							<i class='mdi mdi-file-table align-bottom me-2 text-muted' style='font-size: 18px;'></i> Órdenes de Compra
        // 						</a>
        // 					</li>";
    					
    				// 	}
    							
				$acciones .= "</ul>
			</div>";
            
            $dataServerside[$key]['acciones'] = $acciones;
        }
        
        $datos = [
                // 'draw' => $this->request->getGet('draw'),
            'data'              => $dataServerside,
            'recordsTotal'      => $recordsTotal,
            'recordsFiltered'   => (int) $recordsFiltered
        ];
        
        echo json_encode($datos, JSON_NUMERIC_CHECK);
    }

	public function registrarProveedor()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $ruc                = $this->request->getPost('ruc');
        $proveedor          = mb_strtoupper($this->request->getPost('proveedor'));
        $contacto           = mb_strtoupper($this->request->getPost('contacto'));
        $distrito           = $this->request->getPost('distrito');
        $direccion          = mb_strtoupper($this->request->getPost('direccion'));
        $correo             = $this->request->getPost('correo');
        $telefono01         = $this->request->getPost('telefono01');
        $telefono02         = $this->request->getPost('telefono02');
        $formapago          = $this->request->getPost('formapago');
        $cuentadetraccion   = $this->request->getPost('cuenta_detraccion');
        $codigodetraccion   = $this->request->getPost('codigo_detraccion');
        $observaciones      = $this->request->getPost('observaciones');
        
        $tipologia          = $this->request->getPost('tipologia');
        
        $modalidadpago      = $this->request->getPost('modalidadpago');
        $banco              = $this->request->getPost('banco');
        $cuentabancaria     = $this->request->getPost('cuenta');
        $cuentainterbancaria= $this->request->getPost('cci');
        $moneda             = $this->request->getPost('moneda');
        $prioridad          = $this->request->getPost('prioridad');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($ruc, 'required|trim|numeric|minlength[1]|maxlength[20]', 'RUC');
        $error .= $this->complementos->validaCampo($proveedor, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Proveedor');
        $error .= $this->complementos->validaCampo($contacto, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Contacto');
        $error .= $this->complementos->validaCampo($distrito, 'trim|numeric', 'ID Distrito');
        $error .= $this->complementos->validaCampo($direccion, 'trim|alphaspecial|minlength[1]|maxlength[200]', 'Dirección');
        $error .= $this->complementos->validaCampo($correo, 'trim|email|minlength[1]|maxlength[150]', 'Email');
        $error .= $this->complementos->validaCampo($telefono01, 'trim|numeric|minlength[7]|maxlength[9]', 'Telefono 01');
        $error .= $this->complementos->validaCampo($telefono02, 'trim|numeric|minlength[7]|maxlength[9]', 'Telefono 02');
        $error .= $this->complementos->validaCampo($formapago, 'required|trim|alphanumeric|minlength[1]|maxlength[70]', 'Forma Pago');
        $error .= $this->complementos->validaCampo($cuentadetraccion, 'trim|minlength[1]|maxlength[25]', 'Cuenta Detracción');
        $error .= $this->complementos->validaCampo($codigodetraccion, 'trim|minlength[1]|maxlength[3]', 'Código Detracción');
        $error .= $this->complementos->validaCampo($observaciones, 'trim', 'Observaciones');
        
        if(empty($tipologia))
        {
            $error .= "<li>Debe seleccionar una tipología como mínimo.</li>";
        }
        
        if(empty($modalidadpago))
        {
            $error .= "<li>Debe agregar una modalidad de pago como mínimo.</li>";
        }
        
        if(!empty($prioridad))
        {
            $cantidadPrioridad = array_count_values($prioridad);
            
            if($cantidadPrioridad[1] > 1)
            {
                $error .= "<li>Solo se debe agregar una modalidad de pago con prioridad 1.</li>";
            }
        }
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereExistencia = array(
            "RUC" => $ruc
        );
        
		$rucExistente = $this->proveedor->where($whereExistencia)->findAll();
        
        if(count($rucExistente)>0)
        {
            $msgExistencia .= "<li>El RUC ya fue registrado anteriormente. [CAMPO] <small>RUC</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS A PROVEEDOR
        * ----------------------------
        */

        $data = array (
            'Nombre'            => $proveedor,
            'RUC'               => $ruc,
            'Contacto'          => $contacto,
            'IDDistrito'        => $distrito,
            'Direccion'         => $direccion,
            'Telefono01'        => $telefono01,
            'Telefono02'        => $telefono02,
            'Email'             => $correo,
            'FormaPago'         => $formapago,
            'CuentaDetraccion'  => $cuentadetraccion,
            'CodigoDetraccion'  => $codigodetraccion,
            'Observacion'       => $observaciones,
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => "Creación de proveedor.",    
            'Estado'            => 'A'
        );

        $lastIdProveedor = $this->proveedor->insert($data, TRUE);

        if($lastIdProveedor !== FALSE){
            $idProveedor = $lastIdProveedor;
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar el proveedor. Inténtelo luego.</li>[P]");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
            
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS A PROVEEDOR-TIPOLOGÍA
        * ----------------------------
        */

        $dataTipologia = array();

        foreach($tipologia as $value)
        {
            $dataTipologia[] = array (
                'IDProveedor'       => $idProveedor, 
                'IDTipologia'       => $value, 
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual,    
                'Localhost'         => $this->request->getIPAddress()
            );
        }
        $lastIdTipologia = $this->proveedorTipologia->insertBatch($dataTipologia);
        
        if($lastIdProveedor === FALSE)
        {
            $this->proveedor->delete(["IDProveedor", $idProveedor]);
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar el proveedor. Inténtelo luego.</li>[PT]");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
            
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS A PROVEEDOR-PAGO
        * ----------------------------
        */

        $dataPago = array();

        foreach($modalidadpago as $key=>$detalle)
        {
            if($detalle != '')
            {
                $dataPago[] = array (
                    'IDProveedor'           => $idProveedor, 
                    'ModalidadPago'         => $detalle,  
                    'Banco'                 => $banco[$key], 
                    'CuentaBancaria'        => $cuentabancaria[$key], 
                    'CuentaInterbancaria'   => $cuentainterbancaria[$key], 
                    'Moneda'                => $moneda[$key],  
                    'Prioridad'             => $prioridad[$key],
                    'UsuarioCrea'           => $this->items['id'],
                    'FechaCrea'             => $fechaActual,    
                    'Localhost'             => $this->request->getIPAddress(),
                    'UsuarioEstado'         => $this->items['id'],
                    'FechaEstado'           => $fechaActual,    
                    'MotivoEstado'          => "Creación de modalidad de pago de proveedor.",    
                    'Estado'                => 'A'
                );
            }
        }
        $lastId = $this->proveedorPago->insertBatch($dataPago);
        
        if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $proveedor);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		} 
		else
		{
		    $this->proveedorTipologia->delete(["IDProveedor", $idProveedor]);
		    $this->proveedor->delete(["IDProveedor", $idProveedor]);
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar el proveedor. Inténtelo luego.</li>[PP]");
            echo $this->alertas->alertaError($message);
            EXIT;
		}
	}
	
	public function obtenerDatosProveedor()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idProveedor = $this->request->getPost('idProveedor');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idProveedor, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosProveedor = $this->proveedor->obtenerProveedor($idProveedor);
		
		if(isset($datosProveedor['IDDistrito']) && $datosProveedor['IDDistrito'] != NULL && $datosProveedor['IDDistrito'] != '')
        {
            $region = $this->regionDistrito->obtenerRegionxIDDistrito($datosProveedor['IDDistrito']);
            $datosProveedor['IDDepartamento'] = $region['IDDepartamento'];
            $datosProveedor['Departamento']   = $region['Departamento'];
            $datosProveedor['IDProvincia']    = $region['IDProvincia'];
            $datosProveedor['Provincia']      = $region['Provincia'];
            $datosProveedor['Distrito']       = $region['Distrito'];
            $datosProveedor['IDPais']         = $region['IDPais'];
            $datosProveedor['Pais']           = $region['Pais'];
        }
        else
        {
            $datosProveedor['IDDepartamento'] = "";
            $datosProveedor['Departamento']   = "";
            $datosProveedor['IDProvincia']    = "";
            $datosProveedor['Provincia']      = "";
            $datosProveedor['Distrito']       = "";
            $datosProveedor['IDPais']         = "";
            $datosProveedor['Pais']           = "";
        }
        
		$simboloMoneda = $this->globales->monedas()[$datosProveedor['Moneda']]['SIMBOLO'];
		
		if(!empty($datosProveedor)){
			$resultado = array(
				'idrequerimiento'   => (string) $idProveedor,
				'proveedor'         => (string) $datosProveedor['Nombre'],
				'ruc'               => (string) $datosProveedor['RUC'],
				'contacto'          => (string) $datosProveedor['Contacto'],
				'idpais'            => (string) $datosProveedor['IDPais'],
				'iddepartamento'    => (string) $datosProveedor['IDDepartamento'],
				'idprovincia'       => (string) $datosProveedor['IDProvincia'],
				'iddistrito'        => (string) $datosProveedor['IDDistrito'],
				'pais'              => (string) $datosProveedor['Pais'],
				'departamento'      => (string) $datosProveedor['Departamento'],
				'provincia'         => (string) $datosProveedor['Provincia'],
				'distrito'          => (string) $datosProveedor['Distrito'],
				'direccion'         => (string) $datosProveedor['Direccion'],
				'correo'            => (string) $datosProveedor['Email'],
				'telefono01'        => (string) $datosProveedor['Telefono01'],
				'telefono02'        => (string) $datosProveedor['Telefono02'],
				'formapago'         => (string) $datosProveedor['FormaPago'],
				'tipologia'         => (string) $datosProveedor['TIPOLOGIAS'],
				'cuentadetraccion'  => (string) $datosProveedor['CuentaDetraccion'],
				'codigodetraccion'  => (string) $datosProveedor['CodigoDetraccion'],
				'modalidadpago'     => (string) $datosProveedor['ModalidadPago'],
				'banco'             => (string) $datosProveedor['Banco'],
				'cuentabancaria'    => (string) $datosProveedor['CuentaBancaria'],
				'cci'               => (string) $datosProveedor['CuentaInterbancaria'],
				'moneda'            => (string) $datosProveedor['Moneda'],
				'simbolomoneda'     => (string) $simboloMoneda
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarProveedor($idProveedor)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $ruc                = $this->request->getPost('ruc_e');
        $proveedor          = mb_strtoupper($this->request->getPost('proveedor_e'));
        $contacto           = mb_strtoupper($this->request->getPost('contacto_e'));
        $distrito           = $this->request->getPost('distrito_e');
        $direccion          = mb_strtoupper($this->request->getPost('direccion_e'));
        $correo             = $this->request->getPost('correo_e');
        $telefono01         = $this->request->getPost('telefono01_e');
        $telefono02         = $this->request->getPost('telefono02_e');
        $formapago          = $this->request->getPost('formapago_e');
        $cuentadetraccion   = $this->request->getPost('cuenta_detraccion_e');
        $codigodetraccion   = $this->request->getPost('codigo_detraccion_e');
        $observaciones      = $this->request->getPost('observaciones_e');
        
        $tipologia          = $this->request->getPost('tipologia_e');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($ruc, 'required|trim|numeric|minlength[1]|maxlength[20]', 'RUC');
        $error .= $this->complementos->validaCampo($proveedor, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Proveedor');
        $error .= $this->complementos->validaCampo($contacto, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Contacto');
        $error .= $this->complementos->validaCampo($distrito, 'trim|numeric', 'ID Distrito');
        $error .= $this->complementos->validaCampo($direccion, 'trim|alphaspecial|minlength[1]|maxlength[200]', 'Dirección');
        $error .= $this->complementos->validaCampo($correo, 'trim|email|minlength[1]|maxlength[150]', 'Email');
        $error .= $this->complementos->validaCampo($telefono01, 'trim|numeric|minlength[7]|maxlength[9]', 'Telefono 01');
        $error .= $this->complementos->validaCampo($telefono02, 'trim|numeric|minlength[7]|maxlength[9]', 'Telefono 02');
        $error .= $this->complementos->validaCampo($formapago, 'required|trim|alphanumeric|minlength[1]|maxlength[70]', 'Forma Pago');
        $error .= $this->complementos->validaCampo($cuentadetraccion, 'trim|minlength[1]|maxlength[25]', 'Cuenta Detracción');
        $error .= $this->complementos->validaCampo($codigodetraccion, 'trim|minlength[1]|maxlength[3]', 'Código Detracción');
        $error .= $this->complementos->validaCampo($observaciones, 'trim', 'Observaciones');
        
        if(empty($tipologia))
        {
            $error .= "<li>Debe seleccionar una tipología como mínimo.</li>";
        }
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'Nombre'            => $proveedor,
            'RUC'               => $ruc,
            'Contacto'          => $contacto,
            'IDDistrito'        => $distrito,
            'Direccion'         => $direccion,
            'Telefono01'        => $telefono01,
            'Telefono02'        => $telefono02,
            'Email'             => $correo,
            'FormaPago'         => $formapago,
            'CuentaDetraccion'  => $cuentadetraccion,
            'CodigoDetraccion'  => $codigodetraccion,
            'Observacion'       => $observaciones,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->proveedor->update([$idProveedor], $data);

        if($lastId !== FALSE){
             
            /*
            * ----------------------------
            * INSERCIÓN DE DATOS A PROVEEDOR-TIPOLOGÍA
            * ----------------------------
            */
            
            $this->proveedorTipologia->where('IDProveedor', $idProveedor)->delete();
    
            $dataTipologia = array();
    
            foreach($tipologia as $value)
            {
                $dataTipologia[] = array (
                    'IDProveedor'       => $idProveedor, 
                    'IDTipologia'       => $value, 
                    'UsuarioRegistra'   => $this->items['id'],
                    'FechaRegistra'     => $fechaActual,    
                    'Localhost'         => $this->request->getIPAddress()
                );
            }
            $lastIdTipologia = $this->proveedorTipologia->insertBatch($dataTipologia);
            
            $message = sprintf($this->mensajeError->msg503, $proveedor);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }		
	}
	
    public function modificarEstadoProveedor()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idProveedor = $this->request->getPost('idProveedor');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idProveedor, 'required|trim|numeric', 'ID Proveedor');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->proveedor->update([$idProveedor], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idProveedor);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	public function listadoProveedores()
	{
    	/*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        
        $whereProveedor = array('Estado' => "A");
        $listadoProveedores = $this->proveedor->listadoProveedor($whereProveedor);
        
        $proveedores=array();

		if (!empty($listadoProveedores)) {
            foreach ($listadoProveedores as $items) {
                
                $proveedores[] = array(
					'id' => (string) $items['IDProveedor'],
         	        'text' => (string) $items['RUC'].' | '.$items['Nombre'],
                );
                    
            }

            $resultado = array(
				'listadoProveedores' => json_encode($proveedores)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado);		
	}
	
	public function listadoProveedoresAutocompletado()
	{
    	$elemento = $this->request->getPost('term');
    	
    	$array = array(
    	    "variable"  => $elemento['term'],
    	    "Estado"    => "A"
    	);
    	
        $listado = $this->proveedor->listadoProveedoresAutocompletado($array);
        
        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IDProveedor'],
                'text' => (string) $items['RUC']." | ".$items['Nombre']
            );
        }

        echo json_encode($elementos);		
	}
	
	/**************************************************************************/
	
    /********************* MODALIDAD DE PAGO - PROVEEDOR **********************/
    
    public function recargarTablaModalidadPagoProveedor()
    {
        $resultado['data'] = array();
        
        $idProveedor = $this->request->getPost("idProveedor");
        $moneda = $this->globales->monedas();
            
        $listadoModalidadPago = $this->proveedorPago->listarModalidadPagoProveedor($idProveedor);
        
        foreach($listadoModalidadPago as $key=>$item)
        {
            $resultado['data'][$key] = array(
				'idproveedor'           => (string) $idProveedor,
				'idproveedorpago'       => (string) $item['IDProveedorPago'],
				'codigomodalidadpago'   => (string) $item['CodigoModalidadPago'],
				'modalidadpago'         => (string) $item['ModalidadPago'],
				'codigobanco'           => (string) $item['CodigoBanco'],
				'banco'                 => (string) $item['NombreBanco'],
				'cuentabancaria'        => (string) $item['CuentaBancaria'],
				'cuentainterbancaria'   => (string) $item['CuentaInterbancaria'],
                'moneda'                => (string) "(".$moneda[$item['Moneda']]['SIMBOLO'].") ".$moneda[$item['Moneda']]['NOMBRE'],
				'prioridad'             => (string) $item['Prioridad'],
				'estado'                => (string) $item['Estado'],
				'acciones'              => (string) ""
			);
        }
        
		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);
    }
    
	public function registrarModalidadPagoProveedor()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        $resultado = array(
			'insert'    => (string) false,
			'mensaje'   => (string) "Error"
		);

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idProveedor          = $this->request->getPost('idproveedor_pp');
        
        $modalidadpago      = $this->request->getPost('modalidadPago_pp');
        $banco              = $this->request->getPost('banco_pp');
        $cuentabancaria     = $this->request->getPost('nrocuenta_pp');
        $cuentainterbancaria= $this->request->getPost('cci_pp');
        $moneda             = $this->request->getPost('moneda_pp');
        $prioridad          = $this->request->getPost('prioridad_pp');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idProveedor, 'required|trim|numeric', 'ID Proveedor');
        $error .= $this->complementos->validaCampo($modalidadpago, 'required|trim|alpha|minlength[1]|maxlength[50]', 'Modalidad de Pago');
        $error .= $this->complementos->validaCampo($banco, 'required|trim|alpha|minlength[1]|maxlength[50]', 'Banco');
        $error .= $this->complementos->validaCampo($cuentabancaria, 'required|trim|minlength[1]|maxlength[50]', 'Cuenta Bancaria');
        $error .= $this->complementos->validaCampo($cuentainterbancaria, 'required|trim|minlength[1]|maxlength[50]', 'Cuenta Interbancaria');
        $error .= $this->complementos->validaCampo($moneda, 'required|trim|alpha|minlength[1]|maxlength[5]', 'Moneda');
        $error .= $this->complementos->validaCampo($prioridad, 'required|trim|numeric', 'Prioridad');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			echo json_encode($resultado);
			EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        if($prioridad == 1)
        {
            $wherePrioridad = array(
                "IDProveedor"   => $idProveedor,
                "Prioridad"     => "1"
            );
            
    		$prioridadExistente = $this->proveedorPago->where($wherePrioridad)->findAll();
            
            if(count($prioridadExistente)>0)
            {
                $msgExistencia .= "<li>La prioridad 1 ya fue registrada para el proveedor seleccionado. [CAMPO] <small>PRIORIDAD</small></li>";
            }
        }
        
        $whereModalidad = array(
            "IDProveedor"           => $idProveedor,
            "ModalidadPago"         => $modalidadpago,
            "Banco"                 => $banco,
            "CuentaBancaria"        => $cuentabancaria,
            "CuentaInterbancaria"   => $cuentainterbancaria,
            "Moneda"                => $moneda
        );
        
		$mppExistente = $this->proveedorPago->where($whereModalidad)->findAll();
        
        if(count($mppExistente)>0)
        {
            $msgExistencia .= "<li>La modalidad de pago ya fue registrado para el proveedor. [CAMPO] <small>MODALIDAD DE PAGO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaPeligro($message)
			);
			echo json_encode($resultado);
			EXIT;
        }
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS A PROVEEDOR
        * ----------------------------
        */

        $data = array (
            'IDProveedor'           => $idProveedor,
            'ModalidadPago'         => $modalidadpago,
            'Banco'                 => $banco,
            'CuentaBancaria'        => $cuentabancaria,
            'CuentaInterbancaria'   => $cuentainterbancaria,
            'Moneda'                => $moneda,
            'Prioridad'             => $prioridad,
            'UsuarioCrea'           => $this->items['id'],
            'FechaCrea'             => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress(),
            'UsuarioEstado'         => $this->items['id'],
            'FechaEstado'           => $fechaActual,    
            'MotivoEstado'          => "Creación de modalidad de pago de proveedor.",    
            'Estado'                => 'A'
        );

        $lastIdProveedor = $this->proveedorPago->insert($data, TRUE);
        
        if($lastIdProveedor !== FALSE){
            $message = sprintf($this->mensajeError->msg201, "<li>La modalidad de pago fue registrada exitosamente.</li>");
            
            $resultado = array(
				'insert'    => (string) true,
				'mensaje'   => (string) $this->alertas->alertaExito($message)
			);
			
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la modalidad de pago del proveedor. Inténtelo luego.</li>");
            
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			
        }
        
        echo json_encode($resultado);
           
	}
	
	public function obtenerDatosModalidadPagoProveedor()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idProveedorPago = $this->request->getPost('idProveedorPago');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idProveedorPago, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosProveedorPago = $this->proveedorPago->where("IDProveedorPago", $idProveedorPago)->first();

		if(!empty($datosProveedorPago)){
			$resultado = array(
				'idproveedorpago'   => (string) $idProveedorPago,
				'cuenta'            => (string) $datosProveedorPago['CuentaBancaria'],
				'cci'               => (string) $datosProveedorPago['CuentaInterbancaria'],
				'prioridad'         => (string) $datosProveedorPago['Prioridad'],
				'banco'             => (string) $datosProveedorPago['Banco'],
				'modalidadpago'     => (string) $datosProveedorPago['ModalidadPago'],
				'moneda'            => (string) $datosProveedorPago['Moneda']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarModalidadPagoProveedor($idProveedorPago)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $modalidadpago      = $this->request->getPost('modalidadPago_pp');
        $banco              = $this->request->getPost('banco_pp');
        $cuentabancaria     = $this->request->getPost('nrocuenta_pp');
        $cuentainterbancaria= $this->request->getPost('cci_pp');
        $moneda             = $this->request->getPost('moneda_pp');
        $prioridad          = $this->request->getPost('prioridad_pp');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($modalidadpago, 'required|trim|alpha|minlength[1]|maxlength[50]', 'Modalidad de Pago');
        $error .= $this->complementos->validaCampo($banco, 'required|trim|alpha|minlength[1]|maxlength[50]', 'Banco');
        $error .= $this->complementos->validaCampo($cuentabancaria, 'required|trim|minlength[1]|maxlength[50]', 'Cuenta Bancaria');
        $error .= $this->complementos->validaCampo($cuentainterbancaria, 'required|trim|minlength[1]|maxlength[50]', 'Cuenta Interbancaria');
        $error .= $this->complementos->validaCampo($moneda, 'required|trim|alpha|minlength[1]|maxlength[5]', 'Moneda');
        $error .= $this->complementos->validaCampo($prioridad, 'required|trim|numeric', 'Prioridad');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			echo json_encode($resultado);
			EXIT;
        }
        
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'ModalidadPago'         => $modalidadpago,
            'Banco'                 => $banco,
            'CuentaBancaria'        => $cuentabancaria,
            'CuentaInterbancaria'   => $cuentainterbancaria,
            'Moneda'                => $moneda,
            'Prioridad'             => $prioridad,
            'UsuarioModifica'       => $this->items['id'],
            'FechaModifica'         => $fechaActual,    
            'Localhost'             => $this->request->getIPAddress()
        );

        $lastId = $this->proveedorPago->update([$idProveedorPago], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg201, "<li>La modalidad de pago fue actualizada exitosamente.</li>");
            
            $resultado = array(
				'insert'    => (string) true,
				'mensaje'   => (string) $this->alertas->alertaExito($message)
			);
			
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al actualizar la modalidad de pago del proveedor. Inténtelo luego.</li>");
            
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			
        }
        
        echo json_encode($resultado);
           		
	}
	
    public function modificarEstadoModalidadPagoProveedor()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idProveedorPago    = $this->request->getPost('idProveedorPago');
        $estado             = $this->request->getPost('estado');
        $motivo             = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idProveedorPago, 'required|trim|numeric', 'ID Modalidad de Pago Proveedor');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			echo json_encode($resultado);
			EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->proveedorPago->update([$idProveedorPago], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg201, "<li>Se cambió el estado de la modalidad de pago exitosamente.</li>");
            
            $resultado = array(
				'insert'    => (string) true,
				'mensaje'   => (string) $this->alertas->alertaExito($message)
			);
			
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al cambiar el estado de la modalidad de pago del proveedor. Inténtelo luego.</li>");
            
            $resultado = array(
				'insert'    => (string) false,
				'mensaje'   => (string) $this->alertas->alertaError($message)
			);
			
        }
        
        echo json_encode($resultado);
           		
    }
    
	/**************************************************************************/
	//Funciones de sistema externo proveedores
    /********************* USUARIOS DE ACCESO - PROVEEDOR **********************/
    
	public function listadoUsuariosAccesoProveedor($idProveedor)
	{
	    if (isset($this->items['id'])) 
    	{
    	    $proveedor = $this->proveedor->where("IDProveedor", $idProveedor)->first();
    	    
    	    $usuarios = $this->proveedorExternos->listadoExternosProveedor($idProveedor);
    	    
            $data = array (
				'session'               => 'on',
				'titulo'                => 'Usuarios Asociados - Proveedor | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Listado de Usuarios de Acceso',
                'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'    => $proveedor['Nombre'],
				'subtitulo'             => 'Listado de Usuarios de Acceso',
				'proveedor'             => $proveedor,
				'listadoUsuarios'       => $usuarios
			);
			
            $data = array_merge($data, $this->items);

            return view('configuracion/listar_proveedor_accesos', $data);
        } else {
            return view('errors/500');
        }
	}
	
	public function registrarUsuarioExternoProveedor()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $idproveedor    = $this->request->getPost('txtIDProveedor');
        $nombres        = ucwords(mb_strtolower($this->request->getPost('txtNombresExterno')));
        $apellidos      = ucwords(mb_strtolower($this->request->getPost('txtApellidosExterno')));
        $nrodocumento   = $this->request->getPost('txtNroDocumentoExterno');
        $nrocontacto    = $this->request->getPost('txtNroContactoExterno');
        $correo         = $this->request->getPost('txtCorreoElectronicoExterno');
        $cargo          = ucwords(mb_strtolower($this->request->getPost('txtCargoExterno')));

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idproveedor, 'required|trim|numeric', 'ID Proveedor');
        $error .= $this->complementos->validaCampo($nombres, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Nombres');
        $error .= $this->complementos->validaCampo($apellidos, 'required|trim|alphaspecial|minlength[1]|maxlength[150]', 'Apellidos');
        $error .= $this->complementos->validaCampo($nrodocumento, 'required|trim|numeric|minlength[1]|maxlength[15]', 'Nro Documento');
        $error .= $this->complementos->validaCampo($nrocontacto, 'trim|numeric|minlength[7]|maxlength[10]', 'Nro Contacto');
        $error .= $this->complementos->validaCampo($correo, 'trim|email|minlength[1]|maxlength[200]', 'Correo Electrónico');
        $error .= $this->complementos->validaCampo($cargo, 'required|trim|alphaspecial|minlength[1]|maxlength[200]', 'Cargo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
		$emailExistente = $this->externosAcceso->where("CorreoElectronico",$correo)->findAll();
		$documentoExistente = $this->externosAcceso->where("NroDocumento",$nrodocumento)->findAll();
        
        if(count($emailExistente)>0)
        {
            $msgExistencia .= "<li>El Correo Electrónico ya fue registrado previamente. [CAMPO] <small>CORREO ELECTRÓNICO</small></li>";
        }

        if(count($documentoExistente)>0)
        {
            $msgExistencia .= "<li>El Nro de Documento ya fue registrada previamente. [CAMPO] <small>NRO DOCUMENTO</small></li>";
        }
        
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'Nombres'           => $nombres,
            'Apellidos'         => $apellidos,
            'NroDocumento'      => $nrodocumento,
            'NroContacto'       => $nrocontacto,
            'CorreoElectronico' => $correo,
            'Cargo'             => $cargo,
            'UsuarioCrea'       => $this->items['id'],
            'FechaCrea'         => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,    
            'MotivoEstado'      => "Creación de usuario externo.",    
            'Estado'            => 'A'
        );

        $lastId = $this->externosAcceso->insert($data, TRUE);

		if($lastId !== FALSE){
		    
		    //Si se inserta con éxito, se asocia al proveedor.
		    $externoProveedor = array (
                'IDExterno'         => $lastId,
                'IDProveedor'       => $idproveedor,
                'UsuarioRegistra'   => $this->items['id'],
                'FechaRegistra'     => $fechaActual
            );
		    
            $this->proveedorExternos->insert($externoProveedor, TRUE);

			$message = sprintf($this->mensajeError->msg502, $nombres.' '.$apellidos);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function eliminarUsuarioExternoProveedor()
	{
	    /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idExterno = $this->request->getPost('idExterno') ;
        $idProveedor = $this->request->getPost('idProveedor');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idExterno, 'required|trim|number', 'ID Usuario Externo');
        $error .= $this->complementos->validaCampo($idProveedor, 'required|trim|number', 'ID Proveedor');
        
        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $whereDelete = array (
            'IDExterno'     => $idExterno, 
            'IDProveedor'   => $idProveedor
        );

        $lastId = $this->proveedorExternos->where($whereDelete)->delete();

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg504, $idExterno);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
    public function busquedaUsuarioExterno()
    {
        $elemento = $this->request->getPost('term');
        
        $where = array(
            "like"      => true,
            "busqueda"  => $elemento['term']
        );
        
        $listado = $this->externosAcceso->listadoExternosAcceso($where);

        $elementos=array();

        foreach ($listado as $items) {
            $elementos[] = array(
                'id' => (string) $items['IDExterno'],
                'text' => (string) $items['Nombres'].' '.$items['Apellidos'].' | '.$items['CorreoElectronico']
            );
        }

        echo json_encode($elementos);
    }

    public function asociarUsuarioExternoProveedor()
    {
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $idExterno      = $this->request->getPost('idExterno');
        $idProveedor    = $this->request->getPost('idProveedor');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($idExterno, 'required|trim|number', 'ID Usuario Externo');
        $error .= $this->complementos->validaCampo($idProveedor, 'required|trim|number', 'ID Proveedor');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $where = array(
            'IDExterno'     => $idExterno,
            'IDProveedor'   => $idProveedor
        );
        
		$combinacionExistente = $this->proveedorExternos->where($where)->findAll();
		
        if(count($combinacionExistente)>0)
        {
            $msgExistencia .= "<li>El usuario está asociado al proveedor. [CAMPO] <small>USUARIO</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }

        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'IDExterno'         => $idExterno, 
            'IDProveedor'       => $idProveedor,
            'UsuarioRegistra'   => $this->items['id'],
            'FechaRegistra'     => $fechaActual
        );

        $lastId = $this->proveedorExternos->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $idExterno);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
	/**************************************************************************/
	
}